#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Drag&Slide", Category = "Animation", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class AnimationDrag_SlideNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0, Order = 0)]
		ISpread<double> FInput;

		[Input("Set", DefaultValue = 0, Order = 1)]
		ISpread<bool> FSet;

		[Input("Friction", DefaultValue = 0.9, MinValue = 0.0, MaxValue = 1.0, Order = 2)]
		ISpread<double> FFriction;

		[Input("Minimum", DefaultValue = -1, Order = 3)]
		ISpread<double> FMini;

		[Input("Maximum", DefaultValue = 1, Order = 4)]
		ISpread<double> FMaxi;
		
		[Input("Mirror", DefaultValue = 0, Order = 5)]
		ISpread<bool> FMirror;

		[Input("Default", DefaultValue = 0, Order = 6)]
		ISpread<double> FDefault;

		[Input("Reset", DefaultValue = 0, Order = 7)]
		ISpread<bool> FReset;

		[Output("Output")]
		ISpread<double> FOutput;

		[Output("LastFrameDifference")]
		ISpread<double> FFrameDif;

		[Output("VelocityOut")]
		ISpread<double> FvelocityOut;


		double[] FLastvalue = new double[0];
		double[] FVelocity = new double[0];
		double[] FPositions = new double[0];




		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;
			FvelocityOut.SliceCount = SpreadMax;
			FFrameDif.SliceCount = SpreadMax;


			if (SpreadMax > FLastvalue.Length)
				Array.Resize(ref FLastvalue, SpreadMax * 2);

			if (SpreadMax > FVelocity.Length)
				Array.Resize(ref FVelocity, SpreadMax * 2);

			if (SpreadMax > FPositions.Length)
				Array.Resize(ref FPositions, SpreadMax * 2);


			for (int i = 0; i < SpreadMax; i++) {


				if (FSet[i]) {
					
					if (FMirror[i]) {
					FPositions[i] = System.Math.Min(FPositions[i], FMaxi[i]);
					FPositions[i] = System.Math.Max(FPositions[i], FMini[i]);
						
					}
					FPositions[i] = FPositions[i] + FInput[i] - FLastvalue[i];

					FVelocity[i] = (FLastvalue[i] - FInput[i]);
					FFrameDif[i] = FVelocity[i];
					//*2 startgain
				} else {
					if (FMirror[i]) {
					FPositions[i] = System.Math.Min(FPositions[i], FMaxi[i]);
					FPositions[i] = System.Math.Max(FPositions[i], FMini[i]);
						
					}
					FVelocity[i] = FVelocity[i] * FFriction[i];
					// * Add velocity and Friction
					FvelocityOut[i] = FVelocity[i];
					//Bounce off Wall
					if (FPositions[i] == FMaxi[i] || FPositions[i] == FMini[i]) {
						FVelocity[i] = FVelocity[i] * -1;

					}

					FPositions[i] = FPositions[i] - FVelocity[i];
				}

				if (FReset[i]) {
					FPositions[i] = FDefault[i];
					FVelocity[i] = 0;
					FLastvalue[i] = 0;
				}


				FOutput[i] = FPositions[i];
				FLastvalue[i] = FInput[i];


			}
		}
	}


}
